//
//  StrokeList.h
//  LDMac
//
//  Created by Marcel Weiher on 29.4.09.
//  Copyright 2009 Livescribe. All rights reserved.
//

#import <Foundation/Foundation.h>

@class Stroke;

@interface StrokeList : NSObject <NSFastEnumeration> {
	NSArray	*strokes;
}

+strokesFromPCC:(NSData*)pccData;
+strokeListWithStrokes:(NSArray*)strokes;
-(NSArray*)strokes;
-(NSUInteger)count;
-(Stroke*)strokeAtIndex:(NSUInteger)index;
- (void)createPCCAtPath:(NSString*)path;
- (void)createPCCAtPath:(NSString*)path sessionStart:(int64_t)startTime sessionEnd:(int64_t)endTime ;
-(long long)timestampOfHitPointX:(float)x y:(float)y;
-(long long)timestampOfHitPointX:(float)xPoint y:(float)yPoint  threshold:(float)threshold;

-(long long)startTime;
-(long long)actualStartTime;
-(long long)endTime;
- (BOOL)containsTime:(long long)timecode;

@end
